/*
 * Decompiled with CFR 0.152.
 */
package lotr.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import lotr.client.LOTRAlignmentTicker;
import lotr.client.LOTRAttackTiming;
import lotr.client.LOTRClientProxy;
import lotr.client.LOTREntityRenderer;
import lotr.client.LOTRKeyHandler;
import lotr.client.LOTRReflectionClient;
import lotr.client.LOTRSpeechClient;
import lotr.client.fx.LOTREntityDeadMarshFace;
import lotr.client.gui.LOTRGuiMap;
import lotr.client.gui.LOTRGuiMenu;
import lotr.client.gui.LOTRGuiMessage;
import lotr.client.gui.LOTRGuiMiniquestTracker;
import lotr.client.gui.LOTRGuiNotificationDisplay;
import lotr.client.model.LOTRModelCompass;
import lotr.client.render.LOTRCloudRenderer;
import lotr.client.render.LOTRRenderNorthernLights;
import lotr.client.render.entity.LOTRNPCRendering;
import lotr.client.render.tileentity.LOTRTileEntityMobSpawnerRenderer;
import lotr.client.sound.LOTRAmbience;
import lotr.client.sound.LOTRMusicTicker;
import lotr.client.sound.LOTRMusicTrack;
import lotr.common.LOTRConfig;
import lotr.common.LOTRDate;
import lotr.common.LOTRDimension;
import lotr.common.LOTRDrunkenMovementHandler;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRPlayerFallEventHandler2;
import lotr.common.LOTRSquadrons;
import lotr.common.LOTRTime;
import lotr.common.block.LOTRBlockLeavesBase;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.LOTRInvasionStatus;
import lotr.common.entity.LOTRMountFunctions;
import lotr.common.entity.item.LOTREntityPortal;
import lotr.common.entity.npc.LOTREntityBalrog;
import lotr.common.entity.npc.LOTREntityBarrowWight;
import lotr.common.entity.npc.LOTREntityScrapTrader;
import lotr.common.entity.npc.LOTREntitySpiderBase;
import lotr.common.fac.LOTRAlignmentValues;
import lotr.common.fac.LOTRFaction;
import lotr.common.fac.LOTRFactionBounties;
import lotr.common.fac.LOTRFactionRank;
import lotr.common.fac.LOTRFactionRelations;
import lotr.common.fellowship.LOTRFellowshipData;
import lotr.common.item.LOTRItemBanner;
import lotr.common.item.LOTRItemBlowgun;
import lotr.common.item.LOTRItemBow;
import lotr.common.item.LOTRItemCrossbow;
import lotr.common.item.LOTRItemGraal;
import lotr.common.item.LOTRItemMap;
import lotr.common.item.LOTRItemMapPlus;
import lotr.common.item.LOTRItemOwnership;
import lotr.common.item.LOTRItemSpear;
import lotr.common.item.LOTRPoisonedDrinks;
import lotr.common.item.LOTRWeaponStats;
import lotr.common.quest.IPickpocketable;
import lotr.common.util.LOTRColorUtil;
import lotr.common.util.LOTRFunctions;
import lotr.common.util.LOTRLog;
import lotr.common.util.LOTRVersionChecker;
import lotr.common.world.LOTRWorldChunkManager;
import lotr.common.world.LOTRWorldProvider;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenBarrowDowns;
import lotr.common.world.biome.LOTRBiomeGenDeadMarshes;
import lotr.common.world.biome.LOTRBiomeGenMirkwoodCorrupted;
import lotr.common.world.biome.LOTRBiomeGenMistyMountains;
import lotr.common.world.biome.LOTRBiomeGenMorgulVale;
import lotr.common.world.biome.LOTRBiomeGenUtumno;
import lotr.common.world.biome.variant.LOTRBiomeVariant;
import lotr.common.world.map.LOTRConquestGrid;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class LOTRTickHandlerClient {
    private static ResourceLocation portalOverlay = new ResourceLocation("lotr:misc/portal_overlay.png");
    private static ResourceLocation elvenPortalOverlay = new ResourceLocation("lotr:misc/elvenportal_overlay.png");
    private static ResourceLocation morgulPortalOverlay = new ResourceLocation("lotr:misc/morgulportal_overlay.png");
    private static ResourceLocation mistOverlay = new ResourceLocation("lotr:misc/mist_overlay.png");
    private static ResourceLocation frostOverlay = new ResourceLocation("lotr:misc/frost_overlay.png");
    private static ResourceLocation burnOverlay = new ResourceLocation("lotr:misc/burn_overlay.png");
    private static ResourceLocation wightOverlay = new ResourceLocation("lotr:misc/wight.png");
    public static HashMap playersInPortals = new HashMap();
    public static HashMap playersInElvenPortals = new HashMap();
    public static HashMap playersInMorgulPortals = new HashMap();
    private LOTRAmbience ambienceTicker;
    public static int clientTick;
    public static float renderTick;
    private GuiScreen lastGuiOpen;
    private int mistTick;
    private int prevMistTick;
    private float mistFactor;
    private float sunGlare;
    private float prevSunGlare;
    private float rainFactor;
    private float prevRainFactor;
    private int alignmentXBase;
    private int alignmentYBase;
    private int alignmentXCurrent;
    private int alignmentYCurrent;
    private int alignmentXPrev;
    private int alignmentYPrev;
    private boolean firstAlignmentRender = true;
    public static int alignDrainTick;
    public static final int alignDrainTickMax = 200;
    public static int alignDrainNum;
    public static LOTRInvasionStatus watchedInvasion;
    public static LOTRGuiNotificationDisplay notificationDisplay;
    public static LOTRGuiMiniquestTracker miniquestTracker;
    private boolean wasHoldingBannerWithExistingProtection;
    private int bannerRepossessDisplayTick;
    private int frostTick;
    private int burnTick;
    private int drunkennessDirection = 1;
    private int newDate = 0;
    private float utumnoCamRoll = 0.0f;
    public boolean inUtumnoReturnPortal = false;
    public int utumnoReturnX;
    public int utumnoReturnZ;
    private double lastUtumnoReturnY = -1.0;
    private int prevWightLookTick = 0;
    private int wightLookTick = 0;
    public static boolean anyWightsViewed;
    private int prevWightNearTick = 0;
    private int wightNearTick = 0;
    private int prevBalrogNearTick = 0;
    private int balrogNearTick = 0;
    private float balrogFactor;
    public static int scrapTraderMisbehaveTick;
    private float[] storedLightTable;
    private int storedScrapID;
    private boolean addedClientPoisonEffect = false;
    private LOTRMusicTrack lastTrack = null;
    private int musicTrackTick = 0;
    public boolean cancelItemHighlight = false;
    private ItemStack lastHighlightedItemstack;
    private String highlightedItemstackName;

    public LOTRTickHandlerClient() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.ambienceTicker = new LOTRAmbience();
        notificationDisplay = new LOTRGuiNotificationDisplay();
        miniquestTracker = new LOTRGuiMiniquestTracker();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        block82: {
            GuiScreen guiscreen;
            Minecraft minecraft;
            block83: {
                int i;
                WorldClient world;
                EntityClientPlayerMP entityplayer;
                block84: {
                    block85: {
                        minecraft = Minecraft.func_71410_x();
                        entityplayer = minecraft.field_71439_g;
                        world = minecraft.field_71441_e;
                        if (event.phase == TickEvent.Phase.START) {
                            ++clientTick;
                            if (LOTRConfig.fixRenderDistance && !FMLClientHandler.instance().hasOptifine()) {
                                GameSettings gs = Minecraft.func_71410_x().field_71474_y;
                                int renderDistance = gs.field_151451_c;
                                if (renderDistance > 16) {
                                    renderDistance = 16;
                                    gs.field_151451_c = 16;
                                    gs.func_74303_b();
                                    LOTRLog.logger.info("LOTR+: Render distance was above 16 - set to 16 to prevent a vanilla crash");
                                }
                            }
                            if (minecraft.field_71460_t != null && !(minecraft.field_71460_t instanceof LOTREntityRenderer)) {
                                minecraft.field_71460_t = new LOTREntityRenderer(minecraft, minecraft.func_110442_L());
                                ((IReloadableResourceManager)minecraft.func_110442_L()).func_110542_a((IResourceManagerReloadListener)minecraft.field_71460_t);
                                FMLLog.info((String)"LOTR+: Successfully replaced entityrenderer", (Object[])new Object[0]);
                            }
                        }
                        Minecraft mc = Minecraft.func_71410_x();
                        if (mc.field_71439_g != null) {
                            if (mc.field_71439_g.field_71158_b instanceof LOTRPlayerFallEventHandler2) {
                                ((LOTRPlayerFallEventHandler2)mc.field_71439_g.field_71158_b).onUpdate((EntityPlayerSP)mc.field_71439_g);
                            } else if (LOTRPlayerFallEventHandler2.shouldPerform((EntityPlayerSP)mc.field_71439_g)) {
                                LOTRPlayerFallEventHandler2 input = new LOTRPlayerFallEventHandler2(mc.field_71474_y);
                                input.copyData(mc.field_71439_g.field_71158_b);
                                mc.field_71439_g.field_71158_b = input;
                            }
                        }
                        if (event.phase != TickEvent.Phase.END) break block82;
                        LOTRTileEntityMobSpawnerRenderer.onClientTick();
                        if (minecraft.field_71462_r == null) {
                            this.lastGuiOpen = null;
                        }
                        if (FMLClientHandler.instance().hasOptifine()) {
                            int optifineSetting = 0;
                            try {
                                Object field = GameSettings.class.getField("ofTrees").get(minecraft.field_71474_y);
                                if (field instanceof Integer) {
                                    optifineSetting = (Integer)field;
                                }
                            }
                            catch (Exception field) {
                                // empty catch block
                            }
                            boolean fancyGraphics = optifineSetting == 0 ? minecraft.field_71474_y.field_74347_j : (optifineSetting == 1 ? false : optifineSetting == 2);
                            LOTRBlockLeavesBase.setAllGraphicsLevels(fancyGraphics);
                        } else {
                            LOTRBlockLeavesBase.setAllGraphicsLevels(minecraft.field_71474_y.field_74347_j);
                        }
                        if (entityplayer == null || world == null) break block83;
                        if (LOTRConfig.checkUpdates) {
                            LOTRVersionChecker.checkForUpdates();
                        }
                        if (this.isGamePaused(minecraft)) break block84;
                        miniquestTracker.update(minecraft, (EntityPlayer)entityplayer);
                        LOTRAlignmentTicker.updateAll((EntityPlayer)entityplayer, false);
                        if (alignDrainTick > 0 && --alignDrainTick <= 0) {
                            alignDrainNum = 0;
                        }
                        watchedInvasion.tick();
                        boolean isHoldingBannerWithExistingProtection = LOTRItemBanner.isHoldingBannerWithExistingProtection((EntityPlayer)entityplayer);
                        this.bannerRepossessDisplayTick = isHoldingBannerWithExistingProtection && !this.wasHoldingBannerWithExistingProtection ? 60 : (this.bannerRepossessDisplayTick = this.bannerRepossessDisplayTick - 1);
                        this.wasHoldingBannerWithExistingProtection = isHoldingBannerWithExistingProtection;
                        EntityLivingBase viewer = minecraft.field_71451_h;
                        i = MathHelper.func_76128_c((double)viewer.field_70165_t);
                        int j = MathHelper.func_76128_c((double)viewer.field_70121_D.field_72338_b);
                        int k = MathHelper.func_76128_c((double)viewer.field_70161_v);
                        BiomeGenBase biome = world.func_72807_a(i, k);
                        LOTRBiome.updateWaterColor(i, j, k);
                        LOTRBiomeGenUtumno.updateFogColor(i, j, k);
                        LOTRCloudRenderer.updateClouds(world);
                        if (LOTRConfig.aurora) {
                            LOTRRenderNorthernLights.update(viewer);
                        }
                        LOTRSpeechClient.update();
                        LOTRKeyHandler.update();
                        LOTRAttackTiming.update();
                        this.prevMistTick = this.mistTick;
                        if (viewer.field_70163_u >= 72.0 && biome instanceof LOTRBiomeGenMistyMountains && biome != LOTRBiome.mistyMountainsFoothills && world.func_72937_j(i, j, k) && world.func_72972_b(EnumSkyBlock.Block, i, j, k) < 7) {
                            if (this.mistTick < 80) {
                                ++this.mistTick;
                            }
                        } else if (this.mistTick > 0) {
                            --this.mistTick;
                        }
                        if (this.frostTick > 0) {
                            --this.frostTick;
                        }
                        if (this.burnTick > 0) {
                            --this.burnTick;
                        }
                        this.prevWightLookTick = this.wightLookTick;
                        if (anyWightsViewed) {
                            if (this.wightLookTick < 100) {
                                ++this.wightLookTick;
                            }
                        } else if (this.wightLookTick > 0) {
                            --this.wightLookTick;
                        }
                        this.prevWightNearTick = this.wightNearTick;
                        double wightRange = 32.0;
                        List nearbyWights = world.func_72872_a(LOTREntityBarrowWight.class, viewer.field_70121_D.func_72314_b(wightRange, wightRange, wightRange));
                        if (!nearbyWights.isEmpty()) {
                            if (this.wightNearTick < 100) {
                                ++this.wightNearTick;
                            }
                        } else if (this.wightNearTick > 0) {
                            --this.wightNearTick;
                        }
                        this.prevBalrogNearTick = this.balrogNearTick;
                        double balrogRange = 24.0;
                        List nearbyBalrogs = world.func_72872_a(LOTREntityBalrog.class, viewer.field_70121_D.func_72314_b(balrogRange, balrogRange, balrogRange));
                        if (!nearbyBalrogs.isEmpty()) {
                            if (this.balrogNearTick < 100) {
                                ++this.balrogNearTick;
                            }
                        } else if (this.balrogNearTick > 0) {
                            --this.balrogNearTick;
                        }
                        if (LOTRConfig.enableSunFlare && world.field_73011_w instanceof LOTRWorldProvider && !world.field_73011_w.field_76576_e) {
                            this.prevSunGlare = this.sunGlare;
                            MovingObjectPosition look = viewer.func_70614_a(10000.0, renderTick);
                            boolean lookingAtSky = look == null || look.field_72313_a == MovingObjectPosition.MovingObjectType.MISS;
                            boolean biomeHasSun = true;
                            if (biome instanceof LOTRBiome) {
                                biomeHasSun = ((LOTRBiome)biome).hasSky();
                            }
                            float sunPitch = world.func_72826_c(renderTick) * 360.0f - 90.0f;
                            float sunYaw = 90.0f;
                            float yc = MathHelper.func_76134_b((float)((float)Math.toRadians(-sunYaw - 180.0f)));
                            float ys = MathHelper.func_76126_a((float)((float)Math.toRadians(-sunYaw - 180.0f)));
                            float pc = -MathHelper.func_76134_b((float)((float)Math.toRadians(-sunPitch)));
                            float ps = MathHelper.func_76126_a((float)((float)Math.toRadians(-sunPitch)));
                            Vec3 sunVec = Vec3.func_72443_a((double)(ys * pc), (double)ps, (double)(yc * pc));
                            Vec3 lookVec = viewer.func_70676_i(renderTick);
                            double cos = lookVec.func_72430_b(sunVec) / (lookVec.func_72433_c() * sunVec.func_72433_c());
                            float cosThreshold = 0.95f;
                            float cQ = ((float)cos - cosThreshold) / (1.0f - cosThreshold);
                            cQ = Math.max(cQ, 0.0f);
                            float brightness = world.func_72971_b(renderTick);
                            float brightnessThreshold = 0.7f;
                            float bQ = (brightness - brightnessThreshold) / (1.0f - brightnessThreshold);
                            float maxGlare = cQ * (bQ = Math.max(bQ, 0.0f));
                            if (maxGlare > 0.0f && lookingAtSky && !world.func_72896_J() && biomeHasSun) {
                                if (this.sunGlare < maxGlare) {
                                    this.sunGlare += 0.1f * maxGlare;
                                    this.sunGlare = Math.min(this.sunGlare, maxGlare);
                                } else if (this.sunGlare > maxGlare) {
                                    this.sunGlare -= 0.02f;
                                    this.sunGlare = Math.max(this.sunGlare, maxGlare);
                                }
                            } else {
                                if (this.sunGlare > 0.0f) {
                                    this.sunGlare -= 0.02f;
                                }
                                this.sunGlare = Math.max(this.sunGlare, 0.0f);
                            }
                        } else {
                            this.sunGlare = 0.0f;
                            this.prevSunGlare = 0.0f;
                        }
                        if (LOTRConfig.newWeather) {
                            this.prevRainFactor = this.rainFactor;
                            if (world.func_72896_J()) {
                                if (this.rainFactor < 1.0f) {
                                    this.rainFactor += 0.008333334f;
                                    this.rainFactor = Math.min(this.rainFactor, 1.0f);
                                }
                            } else if (this.rainFactor > 0.0f) {
                                this.rainFactor -= 0.0016666667f;
                                this.rainFactor = Math.max(this.rainFactor, 0.0f);
                            }
                        } else {
                            this.rainFactor = 0.0f;
                            this.prevRainFactor = 0.0f;
                        }
                        if (minecraft.field_71474_y.field_74362_aa < 2) {
                            this.spawnEnvironmentFX((EntityPlayer)entityplayer, (World)world);
                        }
                        LOTRClientProxy.customEffectRenderer.updateEffects();
                        if (minecraft.field_71451_h.func_82165_m(Potion.field_76431_k.field_76415_H)) {
                            float f;
                            float drunkenness = minecraft.field_71451_h.func_70660_b(Potion.field_76431_k).func_76459_b();
                            drunkenness /= 20.0f;
                            if (f > 100.0f) {
                                drunkenness = 100.0f;
                            }
                            minecraft.field_71451_h.field_70177_z += (float)this.drunkennessDirection * drunkenness / 20.0f;
                            minecraft.field_71451_h.field_70125_A += MathHelper.func_76134_b((float)((float)minecraft.field_71451_h.field_70173_aa / 10.0f)) * drunkenness / 20.0f;
                            if (world.field_73012_v.nextInt(100) == 0) {
                                this.drunkennessDirection *= -1;
                            }
                        }
                        if (LOTRDimension.getCurrentDimension((World)world) == LOTRDimension.UTUMNO) {
                            if (this.inUtumnoReturnPortal) {
                                if (this.utumnoCamRoll < 180.0f) {
                                    this.utumnoCamRoll += 5.0f;
                                    this.utumnoCamRoll = Math.min(this.utumnoCamRoll, 180.0f);
                                    LOTRReflectionClient.setCameraRoll(minecraft.field_71460_t, this.utumnoCamRoll);
                                }
                            } else if (this.utumnoCamRoll > 0.0f) {
                                this.utumnoCamRoll -= 5.0f;
                                this.utumnoCamRoll = Math.max(this.utumnoCamRoll, 0.0f);
                                LOTRReflectionClient.setCameraRoll(minecraft.field_71460_t, this.utumnoCamRoll);
                            }
                        } else if (this.utumnoCamRoll != 0.0f) {
                            this.utumnoCamRoll = 0.0f;
                            LOTRReflectionClient.setCameraRoll(minecraft.field_71460_t, this.utumnoCamRoll);
                        }
                        if (this.newDate > 0) {
                            --this.newDate;
                        }
                        this.ambienceTicker.updateAmbience((World)world, (EntityPlayer)entityplayer);
                        if (scrapTraderMisbehaveTick <= 0) break block85;
                        if (--scrapTraderMisbehaveTick > 0) break block84;
                        world.field_73011_w.field_76573_f = Arrays.copyOf(this.storedLightTable, this.storedLightTable.length);
                        Entity scrap = world.func_73045_a(this.storedScrapID);
                        if (scrap == null) break block84;
                        scrap.field_70158_ak = false;
                        break block84;
                    }
                    MovingObjectPosition target = minecraft.field_71476_x;
                    if (target != null && target.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && target.field_72308_g instanceof LOTREntityScrapTrader) {
                        LOTREntityScrapTrader scrap = (LOTREntityScrapTrader)target.field_72308_g;
                        if (minecraft.field_71462_r == null && world.field_73012_v.nextInt(50000) == 0) {
                            scrapTraderMisbehaveTick = 400;
                            scrap.field_70158_ak = true;
                            this.storedScrapID = scrap.func_145782_y();
                            float[] lightTable = world.field_73011_w.field_76573_f;
                            this.storedLightTable = Arrays.copyOf(lightTable, lightTable.length);
                            for (int l = 0; l < lightTable.length; ++l) {
                                lightTable[l] = 1.0E-7f;
                            }
                        }
                    }
                }
                if ((entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) && playersInPortals.containsKey(entityplayer)) {
                    List portals = world.func_72872_a(LOTREntityPortal.class, entityplayer.field_70121_D.func_72314_b(8.0, 8.0, 8.0));
                    boolean inPortal = false;
                    for (i = 0; i < portals.size(); ++i) {
                        LOTREntityPortal portal = (LOTREntityPortal)((Object)portals.get(i));
                        if (!portal.field_70121_D.func_72326_a(entityplayer.field_70121_D)) continue;
                        inPortal = true;
                        break;
                    }
                    if (inPortal) {
                        i = (Integer)playersInPortals.get(entityplayer);
                        playersInPortals.put(entityplayer, ++i);
                        if (i >= 100) {
                            minecraft.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("portal.trigger"), (float)(world.field_73012_v.nextFloat() * 0.4f + 0.8f)));
                            playersInPortals.remove(entityplayer);
                        }
                    } else {
                        playersInPortals.remove(entityplayer);
                    }
                }
                this.updatePlayerInPortal((EntityPlayer)entityplayer, playersInElvenPortals, LOTRMod.elvenPortal);
                this.updatePlayerInPortal((EntityPlayer)entityplayer, playersInMorgulPortals, LOTRMod.morgulPortal);
                if (this.inUtumnoReturnPortal) {
                    entityplayer.func_70107_b((double)this.utumnoReturnX + 0.5, entityplayer.field_70163_u, (double)this.utumnoReturnZ + 0.5);
                    if (this.lastUtumnoReturnY >= 0.0 && entityplayer.field_70163_u < this.lastUtumnoReturnY) {
                        entityplayer.func_70107_b(entityplayer.field_70165_t, this.lastUtumnoReturnY, entityplayer.field_70161_v);
                    }
                    this.lastUtumnoReturnY = entityplayer.field_70163_u;
                } else {
                    this.lastUtumnoReturnY = -1.0;
                }
                this.inUtumnoReturnPortal = false;
            }
            LOTRClientProxy.musicHandler.update();
            if (LOTRConfig.displayMusicTrack) {
                LOTRMusicTrack nowPlaying = LOTRMusicTicker.currentTrack;
                if (nowPlaying != this.lastTrack) {
                    this.lastTrack = nowPlaying;
                    this.musicTrackTick = 200;
                }
                if (this.lastTrack != null && this.musicTrackTick > 0) {
                    --this.musicTrackTick;
                }
            }
            if ((guiscreen = minecraft.field_71462_r) != null) {
                if (guiscreen instanceof GuiMainMenu && !(this.lastGuiOpen instanceof GuiMainMenu)) {
                    LOTRLevelData.needsLoad = true;
                    LOTRTime.needsLoad = true;
                    LOTRFellowshipData.needsLoad = true;
                    LOTRFactionBounties.needsLoad = true;
                    LOTRFactionRelations.needsLoad = true;
                    LOTRDate.resetWorldTimeInMenu();
                    LOTRConquestGrid.needsLoad = true;
                    LOTRSpeechClient.clearAll();
                    LOTRAttackTiming.reset();
                    LOTRGuiMenu.resetLastMenuScreen();
                    LOTRGuiMap.clearPlayerLocations();
                    LOTRCloudRenderer.resetClouds();
                    this.firstAlignmentRender = true;
                    watchedInvasion.clear();
                }
                this.lastGuiOpen = guiscreen;
            }
            anyWightsViewed = false;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                if (mc.field_71439_g.field_71158_b instanceof LOTRDrunkenMovementHandler) {
                    ((LOTRDrunkenMovementHandler)mc.field_71439_g.field_71158_b).resetShuffledKeys((EntityPlayerSP)mc.field_71439_g);
                } else if (LOTRDrunkenMovementHandler.shouldHandleDrunkenMovement((EntityPlayerSP)mc.field_71439_g)) {
                    LOTRDrunkenMovementHandler drunkenInput = new LOTRDrunkenMovementHandler(mc.field_71474_y);
                    drunkenInput.copyMovementData(mc.field_71439_g.field_71158_b);
                    mc.field_71439_g.field_71158_b = drunkenInput;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityClientPlayerMP clientPlayer;
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof EntityClientPlayerMP && (clientPlayer = (EntityClientPlayerMP)player).func_70115_ae()) {
            LOTRMountFunctions.sendControlToServer((EntityPlayer)clientPlayer);
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityClientPlayerMP entityplayer = minecraft.field_71439_g;
        WorldClient world = minecraft.field_71441_e;
        if (event.phase == TickEvent.Phase.START) {
            GuiIngame guiIngame;
            renderTick = event.renderTickTime;
            if (this.cancelItemHighlight && LOTRReflectionClient.getHighlightedItemTicks(guiIngame = minecraft.field_71456_v) > 0) {
                LOTRReflectionClient.setHighlightedItemTicks(guiIngame, 0);
                this.cancelItemHighlight = false;
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            if (entityplayer != null && world != null) {
                ScaledResolution resolution;
                if ((world.field_73011_w instanceof LOTRWorldProvider || LOTRConfig.alwaysShowAlignment) && Minecraft.func_71382_s()) {
                    this.alignmentXPrev = this.alignmentXCurrent;
                    this.alignmentYPrev = this.alignmentYCurrent;
                    this.alignmentXCurrent = this.alignmentXBase;
                    int yMove = (int)((float)(this.alignmentYBase - -20) / 10.0f);
                    boolean alignmentOnscreen = (minecraft.field_71462_r == null || minecraft.field_71462_r instanceof LOTRGuiMessage) && !minecraft.field_71474_y.field_74321_H.func_151470_d() && !minecraft.field_71474_y.field_74330_P;
                    this.alignmentYCurrent = alignmentOnscreen ? Math.min(this.alignmentYCurrent + yMove, this.alignmentYBase) : Math.max(this.alignmentYCurrent - yMove, -20);
                    this.renderAlignment(minecraft, renderTick);
                    if (LOTRConfig.enableOnscreenCompass && minecraft.field_71462_r == null && !minecraft.field_71474_y.field_74330_P) {
                        GL11.glPushMatrix();
                        resolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
                        int i = resolution.func_78326_a();
                        resolution.func_78328_b();
                        int compassX = i - 60;
                        int compassY = 40;
                        GL11.glTranslatef((float)compassX, (float)compassY, (float)0.0f);
                        float rotation = entityplayer.field_70126_B + (entityplayer.field_70177_z - entityplayer.field_70126_B) * event.renderTickTime;
                        rotation = 180.0f - rotation;
                        LOTRModelCompass.compassModel.render(1.0f, rotation);
                        GL11.glPopMatrix();
                        if (LOTRConfig.compassExtraInfo) {
                            BiomeGenBase biome;
                            GL11.glPushMatrix();
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            float scale = 0.75f;
                            float invScale = 1.0f / scale;
                            GL11.glScalef((float)scale, (float)scale, (float)scale);
                            int scaledCompassX = (int)((float)compassX * invScale);
                            int scaledCompassY = (int)((float)compassY * invScale);
                            String coords = MathHelper.func_76128_c((double)entityplayer.field_70165_t) + ", " + MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b) + ", " + MathHelper.func_76128_c((double)entityplayer.field_70161_v);
                            FontRenderer fontRenderer = minecraft.field_71466_p;
                            int textWidthCoords = fontRenderer.func_78256_a(coords);
                            int coordY = scaledCompassY + (int)(35.0f * invScale);
                            Gui.func_73734_a((int)(scaledCompassX - textWidthCoords / 2 - 3), (int)(coordY - 2), (int)(scaledCompassX + textWidthCoords / 2 + 3), (int)(coordY + 10), (int)Integer.MIN_VALUE);
                            fontRenderer.func_78276_b(coords, scaledCompassX - textWidthCoords / 2, coordY, 0xFFFFFF);
                            int playerX = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
                            int playerZ = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
                            if (LOTRClientProxy.doesClientChunkExist((World)world, playerX, playerZ) && (biome = world.func_72807_a(playerX, playerZ)) instanceof LOTRBiome) {
                                String biomeName = ((LOTRBiome)biome).getBiomeDisplayName();
                                int textWidthBiome = fontRenderer.func_78256_a(biomeName);
                                int biomeY = scaledCompassY - (int)(37.0f * invScale);
                                Gui.func_73734_a((int)(scaledCompassX - textWidthBiome / 2 - 3), (int)(biomeY - 2), (int)(scaledCompassX + textWidthBiome / 2 + 3), (int)(biomeY + 10), (int)Integer.MIN_VALUE);
                                fontRenderer.func_78276_b(biomeName, scaledCompassX - textWidthBiome / 2, biomeY, 0xFFFFFF);
                            }
                            GL11.glPopMatrix();
                        }
                    }
                }
                if (entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID && minecraft.field_71462_r == null && this.newDate > 0) {
                    int halfMaxDate = 100;
                    float alpha = 0.0f;
                    alpha = this.newDate > halfMaxDate ? (float)(200 - this.newDate) / (float)halfMaxDate : (float)this.newDate / (float)halfMaxDate;
                    String date = LOTRDate.ShireReckoning.getShireDate().getDateName(true);
                    ScaledResolution resolution2 = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
                    int i = resolution2.func_78326_a();
                    int j = resolution2.func_78328_b();
                    float scale = 1.5f;
                    float invScale = 1.0f / scale;
                    i = (int)((float)i * invScale);
                    j = (int)((float)j * invScale);
                    int x = (i - minecraft.field_71466_p.func_78256_a(date)) / 2;
                    int y = (j - minecraft.field_71466_p.field_78288_b) * 2 / 5;
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    minecraft.field_71466_p.func_78276_b(date, x, y, 0xFFFFFF + (LOTRClientProxy.getAlphaInt(alpha) << 24));
                    GL11.glDisable((int)3042);
                    GL11.glScalef((float)invScale, (float)invScale, (float)invScale);
                }
                if (LOTRConfig.displayMusicTrack && minecraft.field_71462_r == null && this.lastTrack != null && this.musicTrackTick > 0) {
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add(StatCollector.func_74838_a((String)"lotr.music.nowPlaying"));
                    String title = this.lastTrack.getTitle();
                    lines.add(title);
                    if (!this.lastTrack.getAuthors().isEmpty()) {
                        String authors = "(";
                        int a = 0;
                        for (String auth : this.lastTrack.getAuthors()) {
                            authors = authors + auth;
                            if (a < this.lastTrack.getAuthors().size() - 1) {
                                authors = authors + ", ";
                            }
                            ++a;
                        }
                        authors = authors + ")";
                        lines.add(authors);
                    }
                    resolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
                    int w = resolution.func_78326_a();
                    int h = resolution.func_78328_b();
                    int border = 20;
                    int x = w - border;
                    int y = h - border - lines.size() * minecraft.field_71466_p.field_78288_b;
                    float alpha = 1.0f;
                    if (this.musicTrackTick >= 140) {
                        alpha = (float)(200 - this.musicTrackTick) / 60.0f;
                    } else if (this.musicTrackTick <= 60) {
                        alpha = (float)this.musicTrackTick / 60.0f;
                    }
                    for (String line : lines) {
                        x = w - border - minecraft.field_71466_p.func_78256_a(line);
                        minecraft.field_71466_p.func_78276_b(line, x, y, 0xFFFFFF + (LOTRClientProxy.getAlphaInt(alpha) << 24));
                        y += minecraft.field_71466_p.field_78288_b;
                    }
                }
            }
            notificationDisplay.updateWindow();
            if (LOTRConfig.enableQuestTracker && minecraft.field_71462_r == null && !minecraft.field_71474_y.field_74330_P) {
                miniquestTracker.drawTracker(minecraft, (EntityPlayer)entityplayer);
            }
        }
    }

    private void updatePlayerInPortal(EntityPlayer entityplayer, HashMap players, Block portalBlock) {
        if ((entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRDimension.MIDDLE_EARTH.dimensionID) && players.containsKey(entityplayer)) {
            boolean inPortal;
            boolean bl = inPortal = entityplayer.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entityplayer.field_70165_t), MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)entityplayer.field_70161_v)) == portalBlock;
            if (inPortal) {
                int i = (Integer)players.get(entityplayer);
                players.put(entityplayer, ++i);
                if (i >= entityplayer.func_82145_z()) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("portal.trigger"), (float)(entityplayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f)));
                    players.remove(entityplayer);
                }
            } else {
                players.remove(entityplayer);
            }
        }
    }

    private void spawnEnvironmentFX(EntityPlayer entityplayer, World world) {
        world.field_72984_F.func_76320_a("lotrEnvironmentFX");
        int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
        int range = 16;
        for (int l = 0; l < 1000; ++l) {
            int i1 = i + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
            int j1 = j + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
            int k1 = k + world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range);
            Block block = world.func_147439_a(i1, j1, k1);
            int meta = world.func_72805_g(i1, j1, k1);
            if (block.func_149688_o() == Material.field_151586_h) {
                BiomeGenBase biome = world.func_72807_a(i1, k1);
                if (biome instanceof LOTRBiomeGenMirkwoodCorrupted && world.field_73012_v.nextInt(20) == 0) {
                    LOTRMod.proxy.spawnParticle("mirkwoodWater", (float)i1 + world.field_73012_v.nextFloat(), (double)j1 + 0.75, (float)k1 + world.field_73012_v.nextFloat(), 0.0, 0.05, 0.0);
                }
                if (biome instanceof LOTRBiomeGenMorgulVale && world.field_73012_v.nextInt(40) == 0) {
                    LOTRMod.proxy.spawnParticle("morgulWater", (float)i1 + world.field_73012_v.nextFloat(), (double)j1 + 0.75, (float)k1 + world.field_73012_v.nextFloat(), 0.0, 0.05, 0.0);
                }
                if (biome instanceof LOTRBiomeGenDeadMarshes && world.field_73012_v.nextInt(800) == 0) {
                    world.func_72838_d((Entity)new LOTREntityDeadMarshFace(world, (float)i1 + world.field_73012_v.nextFloat(), (double)j1 + 0.25 - (double)world.field_73012_v.nextFloat(), (float)k1 + world.field_73012_v.nextFloat()));
                }
            }
            if (block.func_149688_o() != Material.field_151586_h || meta == 0 || world.func_147439_a(i1, j1 - 1, k1).func_149688_o() != Material.field_151586_h) continue;
            for (int i2 = i1 - 1; i2 <= i1 + 1; ++i2) {
                for (int k2 = k1 - 1; k2 <= k1 + 1; ++k2) {
                    Block adjBlock = world.func_147439_a(i2, j1 - 1, k2);
                    int adjMeta = world.func_72805_g(i2, j1 - 1, k2);
                    if (adjBlock.func_149688_o() != Material.field_151586_h || adjMeta != 0 || !world.func_147437_c(i2, j1, k2)) continue;
                    for (int l1 = 0; l1 < 2; ++l1) {
                        double d = (double)i1 + 0.5 + (double)((float)(i2 - i1) * world.field_73012_v.nextFloat());
                        double d1 = (float)j1 + world.field_73012_v.nextFloat() * 0.2f;
                        double d2 = (double)k1 + 0.5 + (double)((float)(k2 - k1) * world.field_73012_v.nextFloat());
                        world.func_72869_a("explode", d, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        world.field_72984_F.func_76319_b();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world instanceof WorldClient) {
            LOTRClientProxy.customEffectRenderer.clearEffectsAndSetWorld(event.world);
        }
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EntityClientPlayerMP entityplayer = mc.field_71439_g;
        float partialTicks = event.partialTicks;
        GuiIngame guiIngame = mc.field_71456_v;
        if (world != null && entityplayer != null) {
            boolean enchantingDisabled;
            int height;
            int width;
            ScaledResolution resolution;
            if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
                mc.field_71441_e.field_72984_F.func_76320_a("lotr_fixHighlightedItemName");
                ItemStack itemstack = LOTRReflectionClient.getHighlightedItemStack(guiIngame);
                if (itemstack != null && !itemstack.func_82837_s() && !LOTREnchantmentHelper.getEnchantList(itemstack).isEmpty()) {
                    this.lastHighlightedItemstack = itemstack;
                    this.highlightedItemstackName = itemstack.func_82837_s() ? itemstack.func_82833_r() : null;
                    itemstack.func_151001_c(LOTREnchantmentHelper.getFullEnchantedName(itemstack, itemstack.func_82833_r()));
                }
                mc.field_71441_e.field_72984_F.func_76319_b();
            }
            if (event.type == RenderGameOverlayEvent.ElementType.HELMET) {
                int i;
                if (this.sunGlare > 0.0f && mc.field_71474_y.field_74320_O == 0) {
                    float brightness = this.prevSunGlare + (this.sunGlare - this.prevSunGlare) * partialTicks;
                    this.renderOverlay(null, brightness *= 1.0f, mc, null);
                }
                if (playersInPortals.containsKey(entityplayer) && (i = ((Integer)playersInPortals.get(entityplayer)).intValue()) > 0) {
                    this.renderOverlay(null, 0.1f + (float)i / 100.0f * 0.6f, mc, portalOverlay);
                }
                if (playersInElvenPortals.containsKey(entityplayer) && (i = ((Integer)playersInElvenPortals.get(entityplayer)).intValue()) > 0) {
                    this.renderOverlay(null, 0.1f + (float)i / (float)entityplayer.func_82145_z() * 0.6f, mc, elvenPortalOverlay);
                }
                if (playersInMorgulPortals.containsKey(entityplayer) && (i = ((Integer)playersInMorgulPortals.get(entityplayer)).intValue()) > 0) {
                    this.renderOverlay(null, 0.1f + (float)i / (float)entityplayer.func_82145_z() * 0.6f, mc, morgulPortalOverlay);
                }
                if (LOTRConfig.enableMistyMountainsMist) {
                    float mistTickF = (float)this.prevMistTick + (float)(this.mistTick - this.prevMistTick) * partialTicks;
                    float mistFactorY = (float)entityplayer.field_70163_u / 256.0f;
                    this.mistFactor = (mistTickF /= 80.0f) * mistFactorY;
                    if (this.mistFactor > 0.0f) {
                        this.renderOverlay(null, this.mistFactor * 0.75f, mc, mistOverlay);
                    }
                } else {
                    this.mistFactor = 0.0f;
                }
                if (this.frostTick > 0) {
                    this.renderOverlay(null, (float)this.frostTick / 80.0f * 0.9f, mc, frostOverlay);
                }
                if (this.burnTick > 0) {
                    this.renderOverlay(null, (float)this.burnTick / 40.0f * 0.6f, mc, burnOverlay);
                }
                if (this.wightLookTick > 0) {
                    this.renderOverlay(null, (float)this.wightLookTick / 100.0f * 0.95f, mc, wightOverlay);
                }
            }
            if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
                LOTREntitySpiderBase spider;
                if (LOTRConfig.meleeAttackMeter) {
                    LOTRAttackTiming.renderAttackMeter(event.resolution, partialTicks);
                }
                if (entityplayer.field_70154_o instanceof LOTREntitySpiderBase && (spider = (LOTREntitySpiderBase)entityplayer.field_70154_o).shouldRenderClimbingMeter()) {
                    mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3042);
                    mc.field_71424_I.func_76320_a("spiderClimb");
                    resolution = event.resolution;
                    width = resolution.func_78326_a();
                    height = resolution.func_78328_b();
                    float charge = spider.getClimbFractionRemaining();
                    int x = width / 2 - 91;
                    int filled = (int)(charge * 183.0f);
                    int top = height - 32 + 3;
                    guiIngame.func_73729_b(x, top, 0, 84, 182, 5);
                    if (filled > 0) {
                        guiIngame.func_73729_b(x, top, 0, 89, filled, 5);
                    }
                    GL11.glEnable((int)3042);
                    mc.field_71424_I.func_76319_b();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            if (event.type == RenderGameOverlayEvent.ElementType.HEALTH && entityplayer.func_70644_a(LOTRPoisonedDrinks.killingPoison) && !entityplayer.func_70644_a(Potion.field_76436_u)) {
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 20));
                this.addedClientPoisonEffect = true;
            }
            boolean bl = enchantingDisabled = !LOTRLevelData.clientside_thisServer_enchanting && world.field_73011_w instanceof LOTRWorldProvider;
            if (event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE && enchantingDisabled) {
                event.setCanceled(true);
                return;
            }
            if (event.type == RenderGameOverlayEvent.ElementType.ALL && enchantingDisabled && entityplayer.field_70154_o == null) {
                GuiIngameForge.left_height -= 6;
                GuiIngameForge.right_height -= 6;
            }
            if (event.type == RenderGameOverlayEvent.ElementType.ARMOR) {
                event.setCanceled(true);
                resolution = event.resolution;
                width = resolution.func_78326_a();
                height = resolution.func_78328_b();
                mc.field_71424_I.func_76320_a("armor");
                GL11.glEnable((int)3042);
                int left = width / 2 - 91;
                int top = height - GuiIngameForge.left_height;
                int level = LOTRWeaponStats.getTotalArmorValue((EntityPlayer)mc.field_71439_g);
                if (level > 0) {
                    for (int i = 1; i < 20; i += 2) {
                        if (i < level) {
                            guiIngame.func_73729_b(left, top, 34, 9, 9, 9);
                        } else if (i == level) {
                            guiIngame.func_73729_b(left, top, 25, 9, 9, 9);
                        } else if (i > level) {
                            guiIngame.func_73729_b(left, top, 16, 9, 9, 9);
                        }
                        left += 8;
                    }
                }
                GuiIngameForge.left_height += 10;
                GL11.glDisable((int)3042);
                mc.field_71424_I.func_76319_b();
                return;
            }
        }
    }

    @SubscribeEvent
    public void onPostRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EntityClientPlayerMP entityplayer = mc.field_71439_g;
        GuiIngame guiIngame = mc.field_71456_v;
        if (world != null && entityplayer != null) {
            if (event.type == RenderGameOverlayEvent.ElementType.ALL && this.lastHighlightedItemstack != null) {
                if (this.highlightedItemstackName != null) {
                    this.lastHighlightedItemstack.func_151001_c(this.highlightedItemstackName);
                } else {
                    this.lastHighlightedItemstack.func_135074_t();
                }
                this.lastHighlightedItemstack = null;
                this.highlightedItemstackName = null;
            }
            if (event.type == RenderGameOverlayEvent.ElementType.BOSSHEALTH && watchedInvasion.isActive()) {
                GL11.glEnable((int)3042);
                FontRenderer fr = mc.field_71466_p;
                ScaledResolution scaledresolution = event.resolution;
                int width = scaledresolution.func_78326_a();
                int barWidth = 182;
                int remainingWidth = (int)(watchedInvasion.getHealth() * (float)(barWidth - 2));
                int barHeight = 5;
                int barX = width / 2 - barWidth / 2;
                int barY = 12;
                if (LOTRTickHandlerClient.isBossActive()) {
                    barY += 20;
                }
                mc.func_110434_K().func_110577_a(LOTRClientProxy.alignmentTexture);
                guiIngame.func_73729_b(barX, barY, 64, 64, barWidth, barHeight);
                if (remainingWidth > 0) {
                    float[] rgb = watchedInvasion.getRGB();
                    GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
                    guiIngame.func_73729_b(barX + 1, barY + 1, 65, 70, remainingWidth, barHeight - 2);
                }
                String s = watchedInvasion.getTitle();
                fr.func_78261_a(s, width / 2 - fr.func_78256_a(s) / 2, barY - 10, 0xFFFFFF);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                GL11.glDisable((int)3042);
            }
            if (event.type == RenderGameOverlayEvent.ElementType.HEALTH && this.addedClientPoisonEffect) {
                entityplayer.func_70618_n(Potion.field_76436_u.field_76415_H);
                this.addedClientPoisonEffect = false;
            }
            if (event.type == RenderGameOverlayEvent.ElementType.TEXT && this.bannerRepossessDisplayTick > 0) {
                String text = StatCollector.func_74837_a((String)"item.lotr.banner.toggleRepossess", (Object[])new Object[]{GameSettings.func_74298_c((int)mc.field_71474_y.field_74311_E.func_151463_i())});
                int fadeAtTick = 10;
                int opacity = (int)((float)this.bannerRepossessDisplayTick * 255.0f / (float)fadeAtTick);
                if ((opacity = Math.min(opacity, 255)) > 0) {
                    ScaledResolution scaledresolution = event.resolution;
                    int width = scaledresolution.func_78326_a();
                    int height = scaledresolution.func_78328_b();
                    int y = height - 59;
                    y -= 12;
                    if (!mc.field_71442_b.func_78755_b()) {
                        y += 14;
                    }
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    FontRenderer fr = mc.field_71466_p;
                    int x = (width - fr.func_78256_a(text)) / 2;
                    fr.func_78276_b(text, x, y, 0xFFFFFF | opacity << 24);
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderDebugText(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P && mc.field_71441_e != null && mc.field_71439_g != null && mc.field_71441_e.func_72959_q() instanceof LOTRWorldChunkManager) {
            mc.field_71441_e.field_72984_F.func_76320_a("lotrBiomeDisplay");
            LOTRWorldChunkManager chunkManager = (LOTRWorldChunkManager)mc.field_71441_e.func_72959_q();
            int i = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
            int j = MathHelper.func_76128_c((double)mc.field_71439_g.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
            LOTRBiome biome = (LOTRBiome)mc.field_71441_e.func_72807_a(i, k);
            LOTRBiomeVariant variant = chunkManager.getBiomeVariantAt(i, k);
            event.left.add(null);
            biome.addBiomeF3Info(event.left, (World)mc.field_71441_e, variant, i, j, k);
            mc.field_71441_e.field_72984_F.func_76319_b();
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        float f = event.partialTicks;
        if (LOTRConfig.aurora && LOTRDimension.getCurrentDimension((World)mc.field_71441_e) == LOTRDimension.MIDDLE_EARTH) {
            LOTRRenderNorthernLights.render(mc, mc.field_71441_e, f);
        }
        mc.field_71460_t.func_78463_b((double)f);
        RenderHelper.func_74518_a();
        LOTRClientProxy.customEffectRenderer.renderParticles((Entity)mc.field_71451_h, f);
        mc.field_71460_t.func_78483_a((double)f);
        if (Minecraft.func_71382_s() && mc.field_71460_t.field_78532_q == 0) {
            mc.field_71424_I.func_76320_a("lotrSpeech");
            LOTRNPCRendering.renderAllNPCSpeeches(mc, (World)mc.field_71441_e, f);
            mc.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public void getItemTooltip(ItemTooltipEvent event) {
        List<String> previousOwners;
        String currentOwner;
        int armorProtect;
        int i;
        String squadron;
        ItemStack itemstack = event.itemStack;
        List tooltip = event.toolTip;
        EntityPlayer entityplayer = event.entityPlayer;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List<LOTREnchantment> enchantments = LOTREnchantmentHelper.getEnchantList(itemstack);
        if (!itemstack.func_82837_s() && !enchantments.isEmpty()) {
            String name = (String)tooltip.get(0);
            name = LOTREnchantmentHelper.getFullEnchantedName(itemstack, name);
            tooltip.set(0, name);
        }
        if (itemstack.func_77973_b() instanceof LOTRSquadrons.SquadronItem && !StringUtils.func_151246_b((String)(squadron = LOTRSquadrons.getSquadron(itemstack)))) {
            ArrayList newTooltip = new ArrayList();
            newTooltip.add(tooltip.get(0));
            newTooltip.add(StatCollector.func_74837_a((String)"item.lotr.generic.squadron", (Object[])new Object[]{squadron}));
            for (i = 1; i < tooltip.size(); ++i) {
                newTooltip.add(tooltip.get(i));
            }
            tooltip.clear();
            tooltip.addAll(newTooltip);
        }
        if (LOTRWeaponStats.isMeleeWeapon(itemstack)) {
            int dmgIndex = -1;
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                String s = (String)tooltip.get(i2);
                if (!s.startsWith(EnumChatFormatting.BLUE.toString())) continue;
                dmgIndex = i2;
                break;
            }
            if (dmgIndex >= 0) {
                ArrayList newTooltip = new ArrayList();
                for (i = 0; i <= dmgIndex - 1; ++i) {
                    newTooltip.add(tooltip.get(i));
                }
                float meleeDamage = LOTRWeaponStats.getMeleeDamageBonus(itemstack);
                newTooltip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)"lotr.weaponstat.meleeDamage", (Object[])new Object[]{Float.valueOf(meleeDamage)}));
                float meleeSpeed = LOTRWeaponStats.getMeleeSpeed(itemstack);
                int pcSpeed = Math.round(meleeSpeed * 100.0f);
                newTooltip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)"lotr.weaponstat.meleeSpeed", (Object[])new Object[]{pcSpeed}));
                float reach = LOTRWeaponStats.getMeleeReachFactor(itemstack);
                int pcReach = Math.round(reach * 100.0f);
                newTooltip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)"lotr.weaponstat.reach", (Object[])new Object[]{pcReach}));
                int kb = LOTRWeaponStats.getTotalKnockback(itemstack);
                if (kb > 0) {
                    newTooltip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)"lotr.weaponstat.kb", (Object[])new Object[]{kb}));
                }
                for (int i3 = dmgIndex + 1; i3 < tooltip.size(); ++i3) {
                    newTooltip.add(tooltip.get(i3));
                }
                tooltip.clear();
                tooltip.addAll(newTooltip);
            }
        }
        if (LOTRWeaponStats.isRangedWeapon(itemstack)) {
            int kb;
            float f;
            tooltip.add("");
            float drawSpeed = LOTRWeaponStats.getRangedSpeed(itemstack);
            if (drawSpeed > 0.0f) {
                int pcSpeed = Math.round(drawSpeed * 100.0f);
                tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.rangedSpeed", (Object[])new Object[]{pcSpeed}));
            }
            float damage = LOTRWeaponStats.getRangedDamageFactor(itemstack, false);
            if (f > 0.0f) {
                int pcDamage = Math.round(damage * 100.0f);
                tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.rangedDamage", (Object[])new Object[]{pcDamage}));
                if (itemstack.func_77973_b() instanceof ItemBow || itemstack.func_77973_b() instanceof LOTRItemCrossbow) {
                    float range = LOTRWeaponStats.getRangedDamageFactor(itemstack, true);
                    int pcRange = Math.round(range * 100.0f);
                    tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.range", (Object[])new Object[]{pcRange}));
                }
            }
            if ((kb = LOTRWeaponStats.getRangedKnockback(itemstack)) > 0) {
                tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.kb", (Object[])new Object[]{kb}));
            }
        }
        if (LOTRWeaponStats.isPoisoned(itemstack)) {
            tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.poison", (Object[])new Object[0]));
        }
        if (LOTRWeaponStats.isBlood(itemstack)) {
            tooltip.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"lotr.weaponstat.blood", (Object[])new Object[0]));
            tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.poison", (Object[])new Object[0]));
        }
        if (LOTRWeaponStats.isBlood1(itemstack)) {
            tooltip.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"lotr.weaponstat.blood", (Object[])new Object[0]));
        }
        if (LOTRWeaponStats.isPoisoned2(itemstack)) {
            tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.poison", (Object[])new Object[0]));
        }
        if (LOTRWeaponStats.isPoisoned3(itemstack)) {
            tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.poison", (Object[])new Object[0]));
        }
        if (LOTRWeaponStats.isPoisoned4(itemstack)) {
            tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.poison", (Object[])new Object[0]));
        }
        if (LOTRWeaponStats.isPoisoned5(itemstack)) {
            tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"lotr.weaponstat.poison", (Object[])new Object[0]));
        }
        if (LOTRWeaponStats.isPoisoned1(itemstack)) {
            tooltip.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74837_a((String)"lotr.weaponstat.wither", (Object[])new Object[0]));
        }
        if ((armorProtect = LOTRWeaponStats.getArmorProtection(itemstack)) > 0) {
            tooltip.add("");
            int pcProtection = Math.round((float)armorProtect / 25.0f * 100.0f);
            tooltip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)"lotr.weaponstat.protection", (Object[])new Object[]{armorProtect, pcProtection}));
        }
        if (!enchantments.isEmpty()) {
            tooltip.add("");
            ArrayList<String> enchGood = new ArrayList<String>();
            ArrayList<String> enchBad = new ArrayList<String>();
            for (LOTREnchantment ench : enchantments) {
                String enchDesc = ench.getNamedFormattedDescription(itemstack);
                if (ench.isBeneficial()) {
                    enchGood.add(enchDesc);
                    continue;
                }
                enchBad.add(enchDesc);
            }
            tooltip.addAll(enchGood);
            tooltip.addAll(enchBad);
        }
        if (LOTRPoisonedDrinks.isDrinkPoisoned(itemstack) && LOTRPoisonedDrinks.canPlayerSeePoisoned(itemstack, entityplayer)) {
            tooltip.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"item.lotr.drink.poison"));
        }
        if ((currentOwner = LOTRItemOwnership.getCurrentOwner(itemstack)) != null) {
            tooltip.add("");
            String ownerFormatted = EnumChatFormatting.RED + StatCollector.func_74837_a((String)"item.lotr.generic.currentOwner", (Object[])new Object[]{currentOwner});
            List ownerLines = fontRenderer.func_78271_c(ownerFormatted, 150);
            for (int i4 = 0; i4 < ownerLines.size(); ++i4) {
                String line = (String)ownerLines.get(i4);
                if (i4 > 0) {
                    line = "  " + line;
                }
                tooltip.add(line);
            }
        }
        if (!(previousOwners = LOTRItemOwnership.getPreviousOwners(itemstack)).isEmpty()) {
            tooltip.add("");
            ArrayList<String> ownerLines = new ArrayList<String>();
            if (previousOwners.size() == 1) {
                String ownerFormatted = EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)"item.lotr.generic.previousOwner", (Object[])new Object[]{previousOwners.get(0)});
                ownerLines.addAll(fontRenderer.func_78271_c(ownerFormatted, 150));
            } else {
                String beginList = EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"item.lotr.generic.previousOwnerList");
                ownerLines.add(beginList);
                for (String previousOwner : previousOwners) {
                    previousOwner = EnumChatFormatting.ITALIC + previousOwner;
                    ownerLines.addAll(fontRenderer.func_78271_c(previousOwner, 150));
                }
            }
            for (int i5 = 0; i5 < ownerLines.size(); ++i5) {
                String line = (String)ownerLines.get(i5);
                if (i5 > 0) {
                    line = "  " + line;
                }
                tooltip.add(line);
            }
        }
        if (IPickpocketable.Helper.isPickpocketed(itemstack)) {
            tooltip.add("");
            String owner = IPickpocketable.Helper.getOwner(itemstack);
            owner = StatCollector.func_74837_a((String)"item.lotr.generic.stolen", (Object[])new Object[]{owner});
            String wanter = IPickpocketable.Helper.getWanter(itemstack);
            wanter = StatCollector.func_74837_a((String)"item.lotr.generic.stolenWanted", (Object[])new Object[]{wanter});
            ArrayList robbedLines = new ArrayList();
            robbedLines.addAll(fontRenderer.func_78271_c(owner, 200));
            robbedLines.addAll(fontRenderer.func_78271_c(wanter, 200));
            for (int i6 = 0; i6 < robbedLines.size(); ++i6) {
                String line = (String)robbedLines.get(i6);
                if (i6 > 0) {
                    line = "  " + line;
                }
                tooltip.add(line);
            }
        }
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150418_aU)) {
            tooltip.set(0, EnumChatFormatting.RED + (String)tooltip.get(0));
        }
        if (LOTRMod.isAprilFools()) {
            String name = (String)tooltip.get(0);
            name = name.replace("kebab", "gyros");
            name = name.replace("Kebab", "Gyros");
            tooltip.set(0, name);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayText(RenderGameOverlayEvent.Text event) {
        int yOffset;
        String coordsText;
        int coordZ;
        int coordX;
        FontRenderer fr;
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP entityplayer = mc.field_71439_g;
        if (mc.field_71439_g.func_70694_bm() != null && mc.field_71439_g.func_70694_bm().func_77973_b() instanceof LOTRItemMap && mc.field_71439_g.func_70694_bm().func_77942_o()) {
            fr = mc.field_71466_p;
            coordX = mc.field_71439_g.func_70694_bm().func_77978_p().func_74762_e("targetX");
            coordZ = mc.field_71439_g.func_70694_bm().func_77978_p().func_74762_e("targetZ");
            coordsText = EnumChatFormatting.GOLD + "X: " + coordX + ", Z: " + coordZ;
            yOffset = entityplayer.field_71075_bZ.field_75098_d ? 36 : 48;
            fr.func_78261_a(coordsText, event.resolution.func_78326_a() / 2 - fr.func_78256_a(coordsText) / 2, event.resolution.func_78328_b() - yOffset, 16766720);
        }
        if (mc.field_71439_g.func_70694_bm() != null && mc.field_71439_g.func_70694_bm().func_77973_b() instanceof LOTRItemMapPlus && mc.field_71439_g.func_70694_bm().func_77942_o()) {
            fr = mc.field_71466_p;
            coordX = mc.field_71439_g.func_70694_bm().func_77978_p().func_74762_e("targetX");
            coordZ = mc.field_71439_g.func_70694_bm().func_77978_p().func_74762_e("targetZ");
            coordsText = EnumChatFormatting.GOLD + "X: " + coordX + ", Z: " + coordZ;
            yOffset = entityplayer.field_71075_bZ.field_75098_d ? 36 : 48;
            fr.func_78261_a(coordsText, event.resolution.func_78326_a() / 2 - fr.func_78256_a(coordsText) / 2, event.resolution.func_78328_b() - yOffset, 16766720);
        }
        if (mc.field_71439_g.func_70694_bm() != null && mc.field_71439_g.func_70694_bm().func_77973_b() instanceof LOTRItemGraal && mc.field_71439_g.func_70694_bm().func_77942_o()) {
            fr = mc.field_71466_p;
            NBTTagCompound nbt = mc.field_71439_g.func_70694_bm().func_77978_p();
            int hasDrink = nbt.func_74762_e("hasDrink");
            if (hasDrink > 0) {
                String potion1Key = nbt.func_74779_i("potion1");
                String potion2Key = hasDrink >= 2 ? nbt.func_74779_i("potion2") : null;
                String potion3Key = hasDrink == 3 ? nbt.func_74779_i("potion3") : null;
                String localizedPotion1 = this.getLocalizedDrinkInfo(potion1Key, nbt);
                String localizedPotion2 = potion2Key != null ? this.getLocalizedDrinkInfo(potion2Key, nbt) : null;
                String localizedPotion3 = potion3Key != null ? this.getLocalizedDrinkInfo(potion3Key, nbt) : null;
                boolean isCreativeMode = entityplayer.field_71075_bZ.field_75098_d;
                this.renderLocalizedDrinkInfo(fr, localizedPotion1, event.resolution.func_78326_a(), event.resolution.func_78328_b(), -73, isCreativeMode);
                if (localizedPotion2 != null) {
                    this.renderLocalizedDrinkInfo(fr, localizedPotion2, event.resolution.func_78326_a(), event.resolution.func_78328_b(), -86, isCreativeMode);
                }
                if (localizedPotion3 != null) {
                    this.renderLocalizedDrinkInfo(fr, localizedPotion3, event.resolution.func_78326_a(), event.resolution.func_78328_b(), -99, isCreativeMode);
                }
            }
        }
    }

    private String getLocalizedDrinkInfo(String potionKey, NBTTagCompound nbt) {
        String localizedPotionName = StatCollector.func_74838_a((String)(potionKey + ".name"));
        float strength = nbt.func_74764_b(potionKey + "_strength") ? nbt.func_74760_g(potionKey + "_strength") : 0.0f;
        int strengthIndex = this.getStrengthIndex(strength);
        EnumChatFormatting typeColor = this.getDrinkColor(potionKey, strengthIndex);
        EnumChatFormatting strengthColor = this.getStrengthColor(strengthIndex);
        String strengthLocalized = this.getLocalizedStrength(strength);
        return typeColor + localizedPotionName;
    }

    private EnumChatFormatting getDrinkColor(String potionKey, int strengthIndex) {
        if (potionKey.contains("AthelasBrew")) {
            return EnumChatFormatting.GREEN;
        }
        if (potionKey.contains("mugBlueDwarvenTonic")) {
            return EnumChatFormatting.LIGHT_PURPLE;
        }
        if (potionKey.contains("mugDwarvenTonic")) {
            return EnumChatFormatting.BLUE;
        }
        if (potionKey.contains("KhamBrew")) {
            return EnumChatFormatting.GOLD;
        }
        if (potionKey.contains("ValinorBrew")) {
            return EnumChatFormatting.AQUA;
        }
        if (potionKey.contains("Miruvor")) {
            return EnumChatFormatting.YELLOW;
        }
        if (potionKey.contains("MorgulDraught")) {
            return EnumChatFormatting.DARK_GREEN;
        }
        if (potionKey.contains("OrcDraught")) {
            return EnumChatFormatting.RED;
        }
        if (potionKey.contains("mugRedDwarvenTonic")) {
            return EnumChatFormatting.DARK_PURPLE;
        }
        if (potionKey.contains("TauredainCocoa")) {
            return EnumChatFormatting.DARK_RED;
        }
        if (potionKey.contains("TorogDraught")) {
            return EnumChatFormatting.GOLD;
        }
        if (potionKey.contains("UrukDraught")) {
            return EnumChatFormatting.DARK_GRAY;
        }
        return EnumChatFormatting.GRAY;
    }

    private EnumChatFormatting getStrengthColor(int index) {
        switch (index) {
            case 0: {
                return EnumChatFormatting.GREEN;
            }
            case 1: {
                return EnumChatFormatting.YELLOW;
            }
            case 2: {
                return EnumChatFormatting.GOLD;
            }
            case 3: {
                return EnumChatFormatting.RED;
            }
            case 4: {
                return EnumChatFormatting.DARK_RED;
            }
        }
        return EnumChatFormatting.WHITE;
    }

    private int getStrengthIndex(float strength) {
        if (strength >= 3.0f) {
            return 4;
        }
        if (strength >= 2.0f) {
            return 3;
        }
        if (strength >= 1.0f) {
            return 2;
        }
        if (strength >= 0.5f) {
            return 1;
        }
        return 0;
    }

    private String getLocalizedStrength(float strength) {
        if (strength == 0.25f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.weak");
        }
        if (strength == 0.5f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.light");
        }
        if (strength == 1.0f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.moderate");
        }
        if (strength == 2.0f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.strong");
        }
        if (strength == 3.0f) {
            return StatCollector.func_74838_a((String)"item.lotr.drink.potent");
        }
        return "";
    }

    private void renderLocalizedDrinkInfo(FontRenderer fr, String localizedInfo, int screenWidth, int screenHeight, int yOffset, boolean isCreativeMode) {
        if (isCreativeMode) {
            yOffset += 14;
        }
        fr.func_78261_a(localizedInfo, screenWidth / 2 - fr.func_78256_a(localizedInfo) / 2, screenHeight + yOffset, 0xFFFFFF);
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        EntityPlayerSP entityplayer = event.entity;
        float fov = event.newfov;
        ItemStack itemstack = entityplayer.func_70694_bm();
        Item item = itemstack == null ? null : itemstack.func_77973_b();
        float usage = -1.0f;
        if (entityplayer.func_71039_bw()) {
            float maxDrawTime = 0.0f;
            if (item instanceof LOTRItemBow) {
                maxDrawTime = ((LOTRItemBow)item).getMaxDrawTime();
            } else if (item instanceof LOTRItemCrossbow) {
                maxDrawTime = ((LOTRItemCrossbow)item).getMaxDrawTime();
            } else if (item instanceof LOTRItemSpear) {
                maxDrawTime = ((LOTRItemSpear)item).getMaxDrawTime();
            } else if (item instanceof LOTRItemBlowgun) {
                maxDrawTime = ((LOTRItemBlowgun)item).getMaxDrawTime();
            }
            if (maxDrawTime > 0.0f) {
                int i = entityplayer.func_71057_bx();
                usage = (float)i / maxDrawTime;
                float f = usage = usage > 1.0f ? 1.0f : (usage = usage * usage);
            }
        }
        if (LOTRItemCrossbow.isLoaded(itemstack)) {
            usage = 1.0f;
        }
        if (usage >= 0.0f) {
            fov *= 1.0f - usage * 0.15f;
        }
        event.newfov = fov;
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase viewer = event.entity;
        WorldClient world = mc.field_71441_e;
        WorldProvider provider = world.field_73011_w;
        int i = MathHelper.func_76128_c((double)viewer.field_70165_t);
        int j = MathHelper.func_76128_c((double)viewer.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)viewer.field_70161_v);
        BiomeGenBase biome = world.func_72807_a(i, k);
        float farPlane = event.farPlaneDistance;
        int fogMode = event.fogMode;
        if (provider instanceof LOTRWorldProvider) {
            float f;
            LOTRBiome lotrbiome = (LOTRBiome)biome;
            float[] fogStartEnd = ((LOTRWorldProvider)provider).modifyFogIntensity(farPlane, fogMode);
            float fogStart = fogStartEnd[0];
            float fogEnd = fogStartEnd[1];
            if (LOTRConfig.newWeather && (lotrbiome.getEnableRain() || lotrbiome.func_76746_c())) {
                float f2;
                float rain = this.prevRainFactor + (this.rainFactor - this.prevRainFactor) * renderTick;
                if (f2 > 0.0f) {
                    float rainOpacityStart = 0.95f;
                    float rainOpacityEnd = 0.2f;
                    fogStart -= fogStart * (rain * rainOpacityStart);
                    fogEnd -= fogEnd * (rain * rainOpacityEnd);
                }
            }
            if (this.mistFactor > 0.0f) {
                float mistOpacityStart = 0.95f;
                float mistOpacityEnd = 0.7f;
                fogStart -= fogStart * (this.mistFactor * mistOpacityStart);
                fogEnd -= fogEnd * (this.mistFactor * mistOpacityEnd);
            }
            float wightFactor = (float)this.prevWightNearTick + (float)(this.wightNearTick - this.prevWightNearTick) * renderTick;
            wightFactor /= 100.0f;
            if (f > 0.0f) {
                float wightOpacityStart = 0.97f;
                float wightOpacityEnd = 0.75f;
                fogStart -= fogStart * (wightFactor * wightOpacityStart);
                fogEnd -= fogEnd * (wightFactor * wightOpacityEnd);
            }
            if (lotrbiome instanceof LOTRBiomeGenBarrowDowns) {
                if (wightFactor > 0.0f) {
                    int sky0 = lotrbiome.getBaseSkyColorByTemp(i, j, k);
                    int sky1 = 9674385;
                    int clouds0 = 0xFFFFFF;
                    int clouds1 = 0xB4B4B4;
                    int fog0 = 0xFFFFFF;
                    int fog1 = 0x9B9B9B;
                    lotrbiome.biomeColors.setSky(LOTRColorUtil.lerpColors_I(sky0, sky1, wightFactor));
                    lotrbiome.biomeColors.setClouds(LOTRColorUtil.lerpColors_I(clouds0, clouds1, wightFactor));
                    lotrbiome.biomeColors.setFog(LOTRColorUtil.lerpColors_I(fog0, fog1, wightFactor));
                } else {
                    lotrbiome.biomeColors.resetSky();
                    lotrbiome.biomeColors.resetClouds();
                    lotrbiome.biomeColors.resetFog();
                }
            }
            this.balrogFactor = (float)this.prevBalrogNearTick + (float)(this.balrogNearTick - this.prevBalrogNearTick) * renderTick;
            this.balrogFactor /= 100.0f;
            if (this.balrogFactor > 0.0f) {
                float balrogOpacityStart = 0.98f;
                float balrogOpacityEnd = 0.75f;
                fogStart -= fogStart * (this.balrogFactor * balrogOpacityStart);
                fogEnd -= fogEnd * (this.balrogFactor * balrogOpacityEnd);
            }
            GL11.glFogf((int)2915, (float)fogStart);
            GL11.glFogf((int)2916, (float)fogEnd);
        }
    }

    @SubscribeEvent
    public void onFogColors(EntityViewRenderEvent.FogColors event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        WorldProvider provider = world.field_73011_w;
        if (provider instanceof LOTRWorldProvider) {
            float[] rgb = new float[]{event.red, event.green, event.blue};
            rgb = ((LOTRWorldProvider)provider).handleFinalFogColors(event.entity, event.renderPartialTicks, rgb);
            event.red = rgb[0];
            event.green = rgb[1];
            event.blue = rgb[2];
        }
        if (this.balrogFactor > 0.0f) {
            int shadowColor = 0x110000;
            float[] rgb = new float[]{event.red, event.green, event.blue};
            rgb = LOTRColorUtil.lerpColors(rgb, shadowColor, this.balrogFactor);
            event.red = rgb[0];
            event.green = rgb[1];
            event.blue = rgb[2];
        }
    }

    private boolean isGamePaused(Minecraft mc) {
        return mc.func_71356_B() && mc.field_71462_r != null && mc.field_71462_r.func_73868_f() && !mc.func_71401_C().func_71344_c();
    }

    private void renderOverlay(float[] rgb, float alpha, Minecraft mc, ResourceLocation texture) {
        ScaledResolution resolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        if (rgb != null) {
            GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)alpha);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        GL11.glDisable((int)3008);
        if (texture != null) {
            mc.func_110434_K().func_110577_a(texture);
        } else {
            GL11.glDisable((int)3553);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)height, -90.0, 0.0, 1.0);
        tessellator.func_78374_a((double)width, (double)height, -90.0, 1.0, 1.0);
        tessellator.func_78374_a((double)width, 0.0, -90.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.func_78381_a();
        if (texture == null) {
            GL11.glEnable((int)3553);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderAlignment(Minecraft mc, float f) {
        EntityClientPlayerMP entityplayer = mc.field_71439_g;
        LOTRPlayerData pd = LOTRLevelData.getData((EntityPlayer)entityplayer);
        LOTRFaction viewingFac = pd.getViewingFaction();
        ScaledResolution resolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = resolution.func_78326_a();
        resolution.func_78328_b();
        this.alignmentXBase = width / 2 + LOTRConfig.alignmentXOffset;
        this.alignmentYBase = 4 + LOTRConfig.alignmentYOffset;
        if (LOTRTickHandlerClient.isBossActive()) {
            this.alignmentYBase += 20;
        }
        if (watchedInvasion.isActive()) {
            this.alignmentYBase += 20;
        }
        if (this.firstAlignmentRender) {
            LOTRAlignmentTicker.updateAll((EntityPlayer)entityplayer, true);
            this.alignmentXPrev = this.alignmentXCurrent = this.alignmentXBase;
            this.alignmentYCurrent = -20;
            this.alignmentYPrev = -20;
            this.firstAlignmentRender = false;
        }
        float alignmentXF = (float)this.alignmentXPrev + (float)(this.alignmentXCurrent - this.alignmentXPrev) * f;
        float alignmentYF = (float)this.alignmentYPrev + (float)(this.alignmentYCurrent - this.alignmentYPrev) * f;
        boolean text = this.alignmentYCurrent == this.alignmentYBase;
        float alignment = LOTRAlignmentTicker.forFaction(viewingFac).getInterpolatedAlignment(f);
        LOTRTickHandlerClient.renderAlignmentBar(alignment, false, viewingFac, alignmentXF, alignmentYF, text, text, text, false);
        if (alignDrainTick > 0 && text) {
            float alpha = 1.0f;
            int fadeTick = 20;
            if (alignDrainTick < fadeTick) {
                alpha = (float)alignDrainTick / (float)fadeTick;
            }
            LOTRTickHandlerClient.renderAlignmentDrain(mc, (int)alignmentXF - 155, (int)alignmentYF + 2, alignDrainNum, alpha);
        }
    }

    public static void renderAlignmentBar(float alignment, boolean isOtherPlayer, LOTRFaction faction, float x, float y, boolean renderFacName, boolean renderValue, boolean renderLimits, boolean renderLimitValues) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP entityplayer = mc.field_71439_g;
        LOTRPlayerData clientPD = LOTRLevelData.getData((EntityPlayer)entityplayer);
        LOTRFactionRank rank = faction.getRank(alignment);
        boolean pledged = clientPD.isPledgedTo(faction);
        LOTRAlignmentTicker ticker = LOTRAlignmentTicker.forFaction(faction);
        float alignMin = 0.0f;
        float alignMax = 0.0f;
        LOTRFactionRank rankMin = null;
        LOTRFactionRank rankMax = null;
        if (!rank.isDummyRank()) {
            alignMin = rank.alignment;
            rankMin = rank;
            LOTRFactionRank nextRank = faction.getRankAbove(rank);
            if (nextRank != null && !nextRank.isDummyRank() && nextRank != rank) {
                alignMax = nextRank.alignment;
                rankMax = nextRank;
            } else {
                alignMax = rank.alignment * 10.0f;
                rankMax = rank;
                while (alignment >= alignMax) {
                    alignMin = alignMax;
                    alignMax = alignMin * 10.0f;
                }
            }
        } else {
            float firstRankAlign;
            LOTRFactionRank firstRank = faction.getFirstRank();
            float f = firstRankAlign = firstRank != null && !firstRank.isDummyRank() ? firstRank.alignment : 10.0f;
            if (Math.abs(alignment) < firstRankAlign) {
                alignMin = -firstRankAlign;
                alignMax = firstRankAlign;
                rankMin = LOTRFactionRank.RANK_ENEMY;
                rankMax = firstRank != null && !firstRank.isDummyRank() ? firstRank : LOTRFactionRank.RANK_NEUTRAL;
            } else if (alignment < 0.0f) {
                alignMax = -firstRankAlign;
                alignMin = alignMax * 10.0f;
                rankMin = rankMax = LOTRFactionRank.RANK_ENEMY;
                while (alignment <= alignMin) {
                    alignMin = (alignMax *= 10.0f) * 10.0f;
                }
            } else {
                alignMin = firstRankAlign;
                alignMax = alignMin * 10.0f;
                rankMin = rankMax = LOTRFactionRank.RANK_NEUTRAL;
                while (alignment >= alignMax) {
                    alignMin = alignMax;
                    alignMax = alignMin * 10.0f;
                }
            }
        }
        float ringProgress = (alignment - alignMin) / (alignMax - alignMin);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(LOTRClientProxy.alignmentTexture);
        int barWidth = 232;
        int barHeight = 14;
        int activeBarWidth = 220;
        float[] factionColors = faction.getFactionRGB();
        GL11.glColor4f((float)factionColors[0], (float)factionColors[1], (float)factionColors[2], (float)1.0f);
        LOTRTickHandlerClient.drawTexturedModalRect(x - (float)(barWidth / 2), y, 0, 14, barWidth, barHeight);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LOTRTickHandlerClient.drawTexturedModalRect(x - (float)(barWidth / 2), y, 0, 0, barWidth, barHeight);
        float ringProgressAdj = (ringProgress - 0.5f) * 2.0f;
        int ringSize = 16;
        float ringX = x - (float)(ringSize / 2) + ringProgressAdj * (float)activeBarWidth / 2.0f;
        float ringY = y + (float)(barHeight / 2) - (float)(ringSize / 2);
        int flashTick = ticker.flashTick;
        if (pledged) {
            LOTRTickHandlerClient.drawTexturedModalRect(ringX, ringY, 16 * Math.round(flashTick / 3), 212, ringSize, ringSize);
        } else {
            LOTRTickHandlerClient.drawTexturedModalRect(ringX, ringY, 16 * Math.round(flashTick / 3), 36, ringSize, ringSize);
        }
        if (faction.isPlayableAlignmentFaction()) {
            float alpha = 0.0f;
            boolean definedZone = false;
            if (faction.inControlZone((EntityPlayer)entityplayer)) {
                alpha = 1.0f;
                definedZone = faction.inDefinedControlZone((EntityPlayer)entityplayer);
            } else {
                alpha = faction.getControlZoneAlignmentMultiplier((EntityPlayer)entityplayer);
                definedZone = true;
            }
            if (alpha > 0.0f) {
                int arrowSize = 14;
                int y0 = definedZone ? 60 : 88;
                int y1 = definedZone ? 74 : 102;
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glColor4f((float)factionColors[0], (float)factionColors[1], (float)factionColors[2], (float)alpha);
                LOTRTickHandlerClient.drawTexturedModalRect(x - (float)(barWidth / 2) - (float)arrowSize, y, 0, y1, arrowSize, arrowSize);
                LOTRTickHandlerClient.drawTexturedModalRect(x + (float)(barWidth / 2), y, arrowSize, y1, arrowSize, arrowSize);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                LOTRTickHandlerClient.drawTexturedModalRect(x - (float)(barWidth / 2) - (float)arrowSize, y, 0, y0, arrowSize, arrowSize);
                LOTRTickHandlerClient.drawTexturedModalRect(x + (float)(barWidth / 2), y, arrowSize, y0, arrowSize, arrowSize);
                GL11.glDisable((int)3042);
            }
        }
        FontRenderer fr = mc.field_71466_p;
        int textX = Math.round(x);
        int textY = Math.round(y + (float)barHeight + 4.0f);
        if (renderLimits) {
            String sMin = rankMin.getShortNameWithGender(clientPD);
            String sMax = rankMax.getShortNameWithGender(clientPD);
            if (renderLimitValues) {
                sMin = StatCollector.func_74837_a((String)"lotr.gui.factions.alignment.limits", (Object[])new Object[]{sMin, LOTRAlignmentValues.formatAlignForDisplay(alignMin)});
                sMax = StatCollector.func_74837_a((String)"lotr.gui.factions.alignment.limits", (Object[])new Object[]{sMax, LOTRAlignmentValues.formatAlignForDisplay(alignMax)});
            }
            int limitsX = barWidth / 2 - 6;
            int xMin = Math.round(x - (float)limitsX);
            int xMax = Math.round(x + (float)limitsX);
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            LOTRTickHandlerClient.drawAlignmentText(fr, xMin * 2 - fr.func_78256_a(sMin) / 2, textY * 2, sMin, 1.0f);
            LOTRTickHandlerClient.drawAlignmentText(fr, xMax * 2 - fr.func_78256_a(sMax) / 2, textY * 2, sMax, 1.0f);
            GL11.glPopMatrix();
        }
        if (renderFacName) {
            String name = faction.factionName();
            LOTRTickHandlerClient.drawAlignmentText(fr, textX - fr.func_78256_a(name) / 2, textY, name, 1.0f);
        }
        if (renderValue) {
            float alignAlpha;
            String alignS;
            int numericalTick = ticker.numericalTick;
            if (numericalTick > 0) {
                alignS = LOTRAlignmentValues.formatAlignForDisplay(alignment);
                alignAlpha = LOTRFunctions.triangleWave(numericalTick, 0.7f, 1.0f, 30.0f);
                int fadeTick = 15;
                if (numericalTick < fadeTick) {
                    alignAlpha *= (float)numericalTick / (float)fadeTick;
                }
            } else {
                alignS = rank.getShortNameWithGender(clientPD);
                alignAlpha = 1.0f;
            }
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            LOTRTickHandlerClient.drawAlignmentText(fr, textX - fr.func_78256_a(alignS) / 2, textY + fr.field_78288_b + 3, alignS, alignAlpha);
            GL11.glDisable((int)3042);
        }
    }

    public static void renderAlignmentDrain(Minecraft mc, int x, int y, int numFactions) {
        LOTRTickHandlerClient.renderAlignmentDrain(mc, x, y, numFactions, 1.0f);
    }

    public static void renderAlignmentDrain(Minecraft mc, int x, int y, int numFactions, float alpha) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.func_110434_K().func_110577_a(LOTRClientProxy.alignmentTexture);
        LOTRTickHandlerClient.drawTexturedModalRect(x, y, 0, 128, 16, 16);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String s = "-" + numFactions;
        FontRenderer fr = mc.field_71466_p;
        LOTRTickHandlerClient.drawBorderedText(fr, x + 8 - fr.func_78256_a(s) / 2, y + 8 - fr.field_78288_b / 2, s, 0xFFFFFF, alpha);
        GL11.glDisable((int)3042);
    }

    public static void drawTexturedModalRect(double x, double y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + (double)height, 0.0, (double)((float)(u + 0) * f), (double)((float)(v + height) * f));
        tessellator.func_78374_a(x + (double)width, y + (double)height, 0.0, (double)((float)(u + width) * f), (double)((float)(v + height) * f));
        tessellator.func_78374_a(x + (double)width, y + 0.0, 0.0, (double)((float)(u + width) * f), (double)((float)(v + 0) * f));
        tessellator.func_78374_a(x + 0.0, y + 0.0, 0.0, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f));
        tessellator.func_78381_a();
    }

    public static void drawAlignmentText(FontRenderer f, int x, int y, String s, float alphaF) {
        LOTRTickHandlerClient.drawBorderedText(f, x, y, s, 16772620, alphaF);
    }

    public static void drawConquestText(FontRenderer f, int x, int y, String s, boolean cleanse, float alphaF) {
        LOTRTickHandlerClient.drawBorderedText(f, x, y, s, cleanse ? 16773846 : 14833677, alphaF);
    }

    public static void drawBorderedText(FontRenderer f, int x, int y, String s, int color, float alphaF) {
        int alpha = (int)(alphaF * 255.0f);
        alpha = MathHelper.func_76125_a((int)alpha, (int)4, (int)255);
        f.func_78276_b(s, x - 1, y - 1, 0 | (alpha <<= 24));
        f.func_78276_b(s, x, y - 1, 0 | alpha);
        f.func_78276_b(s, x + 1, y - 1, 0 | alpha);
        f.func_78276_b(s, x + 1, y, 0 | alpha);
        f.func_78276_b(s, x + 1, y + 1, 0 | alpha);
        f.func_78276_b(s, x, y + 1, 0 | alpha);
        f.func_78276_b(s, x - 1, y + 1, 0 | alpha);
        f.func_78276_b(s, x - 1, y, 0 | alpha);
        f.func_78276_b(s, x, y, color | alpha);
    }

    public void onFrostDamage() {
        this.frostTick = 80;
    }

    public void onBurnDamage() {
        this.burnTick = 40;
    }

    public void updateDate() {
        this.newDate = 200;
    }

    public float getWightLookFactor() {
        float f = (float)this.prevWightLookTick + (float)(this.wightLookTick - this.prevWightLookTick) * renderTick;
        return f /= 100.0f;
    }

    private static boolean isBossActive() {
        return BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0;
    }

    static {
        watchedInvasion = new LOTRInvasionStatus();
        scrapTraderMisbehaveTick = 0;
    }
}

